//
//  AppDelegate.m
//  FaceTest
//
//  Created by Logan Collins on 4/2/12.
//  Copyright (c) 2012 Panic, Inc. All rights reserved.
//

#import "AppDelegate.h"
#import <Quartz/Quartz.h>


@implementation AppDelegate

- (id)init {
    self = [super init];
    if (self) {
        
    }
    return self;
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
    
}

- (BOOL)applicationShouldHandleReopen:(NSApplication *)sender hasVisibleWindows:(BOOL)flag {
    [[self window] makeKeyAndOrderFront:nil];
    return YES;
}

- (IBAction)chooseImage:(id)sender {
    NSOpenPanel *openPanel = [NSOpenPanel openPanel];
    [openPanel setAllowedFileTypes:[NSArray arrayWithObjects:@"public.image", nil]];
    [openPanel beginSheetModalForWindow:[self window] completionHandler:^(NSInteger result) {
        if (result == NSFileHandlingPanelOKButton) {
            NSImage *image = [[NSImage alloc] initWithContentsOfURL:[openPanel URL]];
            [self.imageView setImage:image];
        }
    }];
}

- (IBAction)takeImage:(id)sender {
    IKPictureTaker *pictureTaker = [IKPictureTaker pictureTaker];
    [pictureTaker beginPictureTakerSheetForWindow:[self window] withDelegate:self didEndSelector:@selector(pictureTakerDidEnd:returnCode:contextInfo:) contextInfo:nil];
}

- (void)pictureTakerDidEnd:(IKPictureTaker *)pictureTaker returnCode:(NSInteger)returnCode contextInfo:(void *)contextInfo {
    if (returnCode == NSOKButton) {
        NSImage *image = [pictureTaker outputImage];
        [self.imageView setImage:image];
    }
}

@end
